/*!
*******************************************************************************
* \file             spi_tclMySpinAudioStream.h
* \brief            Implements the Audio functionality for mySPIN
*******************************************************************************
\verbatim
PROJECT:        Gen3 Projects
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Audio Streaming (Lib) Implementation for mySPIN using gstreamer
COPYRIGHT:      &copy; BSOT

HISTORY:
Date       |  Author                          | Modifications
19.02.2016 |  J. Schmidt                      | initial version

\endverbatim
******************************************************************************/

#ifndef __SPI_TCLMYSPINAUDIOSTREAM_H__
#define __SPI_TCLMYSPINAUDIOSTREAM_H__

#include "spi_tclMySpinAudioGstreamer.h"
#include "spi_tclMySPINSndCtrlMonitor.h"
#include "spi_tclMySPINSndCtrlMonitorIF.h"

class spi_tclMySpinAudioStream : public spi_tclMySPINSndCtrlMonitorIF
{

public:
    spi_tclMySpinAudioStream();

    virtual ~spi_tclMySpinAudioStream();


    virtual S32 SetAudioStreamConfig(const audioStreamConfig audioStreamConfig);
    virtual S32 SetAudioStreamInputDevice( std::string szInDeviceName, audioStreamDeviceType audioStreamDeviceType );
    virtual S32 SetAudioStreamOutputDevice( std::string szOutDeviceName );

    virtual S32 StartAudioStream();
    virtual S32 StopAudioStream();

    virtual void vRegisterCallbacks(U32 cou32Context, audioStreamCallbacks);

private:

    spi_tclMySpinAudioGstreamer* m_poGstreamer;
    spi_tclMySPINSndCtrlMonitor* m_poSndCtrlMonitor;

    std::string m_szInDeviceName;
    std::string m_szOutDeviceName;
    audioStreamDeviceType m_enAudioStreamDeviceType;
    bool m_startReceived;
    bool m_configReceived;
    bool m_rateReceived;
    U32 m_lastRate;

    S32 check_start_audio();

    void vSampleRateChanged_CB(U32 u32SampleRate, bool bEndPointEnabled);

};


#endif /* __SPI_TCLMYSPINAUDIOSTREAM_H__ */
